### * <HEADER>
###
attach(NULL, name = "CheckExEnv")
assign("nameEx", 
       local({
	   s <- "__{must remake R-ex/*.R}__"
           function(new) {
               if(!missing(new)) s <<- new else s
           }
       }),
       pos = "CheckExEnv")
## Add some hooks to label plot pages for base and grid graphics
assign("base_plot_hook",
       function() {
           pp <- par(c("mfg","mfcol","oma","mar"))
           if(all(pp$mfg[1:2] == c(1, pp$mfcol[2]))) {
               outer <- (oma4 <- pp$oma[4]) > 0; mar4 <- pp$mar[4]
               mtext(sprintf("help(\"%s\")", nameEx()), side = 4,
                     line = if(outer)max(1, oma4 - 1) else min(1, mar4 - 1),
               outer = outer, adj = 1, cex = .8, col = "orchid", las=3)
           }
       },
       pos = "CheckExEnv")
assign("grid_plot_hook",
       function() {
           grid::pushViewport(grid::viewport(width=grid::unit(1, "npc") - 
                              grid::unit(1, "lines"), x=0, just="left"))
           grid::grid.text(sprintf("help(\"%s\")", nameEx()),
                           x=grid::unit(1, "npc") + grid::unit(0.5, "lines"),
                           y=grid::unit(0.8, "npc"), rot=90,
                           gp=grid::gpar(col="orchid"))
       },
       pos = "CheckExEnv")
setHook("plot.new",     get("base_plot_hook", pos = "CheckExEnv"))
setHook("persp",        get("base_plot_hook", pos = "CheckExEnv"))
setHook("grid.newpage", get("grid_plot_hook", pos = "CheckExEnv"))
assign("cleanEx",
       function(env = .GlobalEnv) {
	   rm(list = ls(envir = env, all.names = TRUE), envir = env)
           RNGkind("default", "default")
	   set.seed(1)
   	   options(warn = 1)
	   .CheckExEnv <- as.environment("CheckExEnv")
	   delayedAssign("T", stop("T used instead of TRUE"),
		  assign.env = .CheckExEnv)
	   delayedAssign("F", stop("F used instead of FALSE"),
		  assign.env = .CheckExEnv)
	   sch <- search()
	   newitems <- sch[! sch %in% .oldSearch]
	   for(item in rev(newitems))
               eval(substitute(detach(item), list(item=item)))
	   missitems <- .oldSearch[! .oldSearch %in% sch]
	   if(length(missitems))
	       warning("items ", paste(missitems, collapse=", "),
		       " have been removed from the search path")
       },
       pos = "CheckExEnv")
assign("ptime", proc.time(), pos = "CheckExEnv")
## at least one package changes these via ps.options(), so do this
## before loading the package.
## Use postscript as incomplete files may be viewable, unlike PDF.
## Choose a size that is close to on-screen devices, fix paper
ps.options(width = 7, height = 7, paper = "a4", reset = TRUE)
grDevices::postscript("crackrec-Ex.ps")
		      
assign("par.postscript", graphics::par(no.readonly = TRUE), pos = "CheckExEnv")
options(contrasts = c(unordered = "contr.treatment", ordered = "contr.poly"), pager="console")
options(warn = 1)    
library('crackrec')

assign(".oldSearch", search(), pos = 'CheckExEnv')
assign(".oldNS", loadedNamespaces(), pos = 'CheckExEnv')
cleanEx(); nameEx("crackplot")
### * crackplot

flush(stderr()); flush(stdout())

### Name: crackplot
### Title: crackplot
### Aliases: crackplot
### Keywords: internal

### ** Examples

## Not run: 
##D mx<-rbmp("image.bmp")
##D result<-crackrec(mx)
##D image(1:dim(mx)[[1]],1:dim(mx)[[2]], mx, col=gray((1:32)/32))
##D crackplot(mx$crackpaths, mx$cracks)
## End(Not run)



cleanEx(); nameEx("crackrec")
### * crackrec

flush(stderr()); flush(stdout())

### Name: crackrec
### Title: crackrec
### Aliases: crackrec
### Keywords: internal

### ** Examples

## Not run: 
##D x<-rbmp("image.bmp")
##D crackrec(x, threshold=123, alpha=0, beta=0)
## End(Not run)



cleanEx(); nameEx("medianfilter")
### * medianfilter

flush(stderr()); flush(stdout())

### Name: medianfilter
### Title: medianfilter
### Aliases: medianfilter
### Keywords: internal

### ** Examples

## Not run: 
##D medianfilter(matrix, mask=25)
## End(Not run)



cleanEx(); nameEx("rbmp")
### * rbmp

flush(stderr()); flush(stdout())

### Name: rbmp
### Title: rbmp
### Aliases: rbmp
### Keywords: internal

### ** Examples

rbmp("image.bmp")

# clipping, with a vertical offset of the clipping rectancle.
rbmp("image.bmp", width=696, height=512, offset.y=41) 



cleanEx(); nameEx("shadow.remove")
### * shadow.remove

flush(stderr()); flush(stdout())

### Name: shadow.remove
### Title: shadow.remove
### Aliases: shadow.remove
### Keywords: internal

### ** Examples

## Not run: 
##D matrix<-rbmp("image.bmp")
##D shadow.remove(matrix)
## End(Not run)



cleanEx(); nameEx("threshold.msi")
### * threshold.msi

flush(stderr()); flush(stdout())

### Name: threshold.msi
### Title: threshold.msi
### Aliases: threshold.msi
### Keywords: internal

### ** Examples

## Not run: 
##D threshold.msi(matrix, bw=30)
##D 
##D # A simple visual test for the threshold value
##D t<-threshold.msi(matrix, bw=30)
##D image(matrix>=t, col=gray((1:32)/32))
## End(Not run)



### * <FOOTER>
###
cat("Time elapsed: ", proc.time() - get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
