impute_missing_values = function(data) {
  cns <- colnames(data)
  for (cn in cns) {
    v <- data[,cn]
    nas <- is.na(v)
    if (any(nas)) {
      data[[sprintf("%s_na", cn)]] <- as.factor(nas)
      v[nas] <- median(v, na.rm=TRUE) 
      data[, cn] <- v
    }
  }
  return(data)
}


remove_constant_columns = function(data) {
  cns <- colnames(data)
  for (cn in cns) {
    if (all(data[,cn] == data[1,cn]))
      data[, cn] <- NULL
  }
  return(data)
}