library("vegan")

##' MST feature
##'
##' @param x A TSP instance
##'
##' @return Statistics describing the depth and distances of the MST.
feature_mst <- function(x) {
  dd <- dist(x)
  d <- as.matrix(dd)
  tr <- spantree(d)    
    
  ## depths of mst
  tr_depth <- spandepth(tr)   
  ## distances within mst
  tr_dists <- tr$dist
  
  return(list(mst_depth_min=min(tr_depth),
              mst_depth_mean=mean(tr_depth),
              mst_depth_median=median(tr_depth),
              mst_depth_max=max(tr_depth),
              mst_depth_sd=sd(tr_depth),
              mst_dists_min=min(tr_dists),
              mst_dists_mean=mean(tr_dists),
              mst_dists_median=median(tr_dists),
              mst_dists_max=max(tr_dists),
              mst_dists_sd=sd(tr_dists),
              mst_dists_sum=sum(tr_dists) / sum(dd)
              ))
}
