##' Modes of edge cost distribution feature
##'
##' @param x A TSP instance
##'
##' @return (estimated) number of modes
feature_modes <- function(x) {
  dists <- as.numeric(dist(x))

  intdens <- function(a, b) {
    mean(y[a:b]) * (d$x[b] - d$x[a])
  }
  
  d <- density(dists)
  y <- d$y
  n <- length(y)
  minidx <- c(1, which(y[2:(n-1)] < y[1:(n-2)] & y[2:(n-1)] < y[3:n]), n+1)
  modemass <- sapply(1:(length(minidx) - 1),
                     function(i) intdens(minidx[i], minidx[i+1]-1))
  list(modes_number=sum(modemass > 0.01))
}
