feature_distance <- function(x) {
  dd <- dist(x)
  ## Missing:
  ## * sum_of_lowest_edge_values
  freq <- table(as.vector(dd))
  mode_freq <- as.numeric(max(freq)) ## as.numeric to strip name attr
  mode_values <- as.numeric(names(freq[freq == mode_freq]))
  mode_quantity <- length(mode_values) / length(dd)
  list(distance_min=min(dd),
       distance_mean=mean(dd),
       distance_median=median(dd),
       distance_max=max(dd),
       distance_sd=sd(dd),
       distance_distances_shorter_mean_distance=sum(dd < mean(dd)) / length(dd),
       distance_distinct_distances=length(unique(dd)) / length(dd),
       distance_mode_frequency=mode_freq,
       distance_mode_quantity=mode_quantity,
       distance_mode_mean=mean(mode_values),
       distance_mean_tour_length=2 / (nrow(x) - 1) * sum(dd)
       )
}
