library("splancs")

##' Convex hull feature
##'
##' @param x A TSP instance
feature_chull <- function(x) {
  hull <- chull(x[, 1], x[, 2])
  area <- areapl(x[hull, ])
  list(chull_area=area,
       chull_points_on_hull=length(hull) / nrow(x))
}
