##' Return the centroid of the point cloud.
##'
##' @param x A TSP instance
feature_centroid <- function(x) {
  centroid <- colMeans(x)

  distance <- apply(x, 1, function(point) {
    v <- point - centroid
    sqrt(sum(v * v))
  })

  list(centroid_centroid_x=centroid[1],
       centroid_centroid_y=centroid[2],
       centroid_min_distance_to_centroid=min(distance),
       centroid_mean_distance_to_centroid=mean(distance),
       centroid_max_distance_to_centroid=max(distance)
       )
}
