dyn.load(paste("lib/fast_two_opt", .Platform$dynlib.ext, sep=""))

fast_two_opt <- local({
  do_fast_two_opt <- getNativeSymbolInfo("do_fast_two_opt")
  function(distance_matrix, initial_tour) {
    if (!is.matrix(distance_matrix))
      distance_matrix <- as.matrix(distance_matrix)
    
    if (missing(initial_tour))
      initial_tour <- sample(1:nrow(distance_matrix))
    
    .Call(do_fast_two_opt, distance_matrix, initial_tour)
  }
})
