approximation_quality <- function(coords, number_of_two_opt_runs=1000L) {
  distance <- as.matrix(dist(coords))
  instance <- TSP(distance)

  ##sol <- solve_TSP(instance, "concorde")
  sol <- concorde(instance)
  l <- tour_length(instance, sol)
  
  ## FIXME: 1000 is probably still "low":
  ll <- replicate(number_of_two_opt_runs, {
    sol <- fast_two_opt(distance)
    tour_length(instance, sol[[1]])
  })
  mean(ll) / l
}

