

### zusammfassen der instanzen in eine Liste pro Kategorie inst_size,type,rnd_type

list_instances <- function(inst_size,type,rnd_type){

        instances <- list(0)

        for (i in c(1:100)){
            if (i < 10){number <- paste("00",i,sep='')
                }else{if (i < 100){number <- paste("0",i,sep='')
                       }else{number <- i}
                }     
        
        if(inst_size < 100){size <- paste("0",inst_size,sep='')
                        }else{size <- inst_size}   
        
        dat <- load(paste(size,"-",rnd_type,"-",type,"-",number,".Rdata",sep=''))
        instances[[i]] <- fitness
        } 
        
return(instances)
}


## anzahl generationen

number_generations <- function(rnd_type){
    
    boxplotdata <- list(0)
    
    k <- 0
    
    for (i in c("easy","hard")){
       for (j in c(25,50,100)){
            
            k <- k+1
            
            dat             <- list_instances(j,i,rnd_type)
            boxplotdata[[k]] <- do.call(rbind,lapply(dat, function(x) sum(x != 0)))
       }
    }
        
    pdf(paste("nr_gen_",rnd_type,".pdf",sep=''))
        boxplot(boxplotdata,names=rep(c(25,50,100),2),main=rnd_type,xlab="instance size",ylab="EA generations")
    abline(v=3.5)
    mtext("easy",cex=1.7,side=3,at=2,line=0.5)
    mtext("hard",cex=1.7,side=3,at=5,line=0.5)
    dev.off()
    
}
               
number_generations("rnd")     
number_generations("nrnd")      


### plots der fitnesswerte

plot_fitness <- function(inst_size,type,rnd_type){
    
  data_fitness <- list_instances(inst_size,type,rnd_type)
  
  pdf(paste("fitness_",inst_size,"_",type,"_",rnd_type,".pdf",sep=''))
   
   lapply(data_fitness,function(x) plot(x[x!=0],type="l",xlab="generations",ylab="fitness",xlim=c(1,5000)))
  dev.off()
}

for (i in c("easy","hard")){
       for (j in c(25,50,100)){
         for (k in c("rnd","nrnd")){

            plot_fitness(j,i,k)
         }
       }
}

 

        
